<?php

namespace Suiterus\Adg\Models\Approvals;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
use Suiterus\Adg\Models\Approvals\UserOvertime;

class OvertimeAccomplishmentReport extends Model
{
    use HasFactory;

    protected $connection = 'adg_db';

    protected $table = 'overtime_accomplishment_reports';

    protected $fillable = [
        'overtime_id',
        'mh_rendered',
        'actual_output',
        'actual_overtime_work',
        'status',
        'remarks'
    ];

    public function __construct(array $attributes = []){
        $this->table = env('ADG_DB_DATABASE') . '.overtime_accomplishment_reports';
        parent::__construct($attributes);
    }

    public function overtime(){
        return $this->belongsTo(UserOvertime::class, 'overtime_id', 'id');
    }
}
