<?php

namespace Suiterus\Adg\Models\Approvals\CTO;

use App\Models\User;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class CTOApplication extends Model
{
    use HasFactory, SoftDeletes;

    protected $connection = 'adg_db';

    protected $table = 'cto_applications';

    protected $fillable = [
        'user_id',
        'coc_points_id',
        'points',
        'reason',
        'start_date',
        'end_date',
        'status',
        'status_remarks',
        'remarks',
        'created_by',
        'updated_by'
    ];

    protected $with = [
        'coc_points'
    ];

    protected $appends = [
        'formatted_start_date',
        'formatted_end_date'
    ];

    public function __construct(array $attributes = []){
        $this->table = env('ADG_DB_DATABASE') . '.cto_applications';
        parent::__construct($attributes);
    }

    public function getPointsAttribute($points) {
        return number_format($points, 2);
    }

    public function user() {
        return $this->belongsTo(User::class, 'user_id', 'id');
    }

    public function coc_points() {
        return $this->belongsTo(COCPoints::class, 'coc_points_id', 'id');
    }

    public function getFormattedStartDateAttribute() {
        return date("M j, Y", strtotime($this->start_date));
    }

    public function getFormattedEndDateAttribute() {
        return date("M j, Y", strtotime($this->end_date));
    }
}
