<?php

namespace Suiterus\Adg\Models\Approvals\CTO;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
use Suiterus\Adg\Models\Approvals\CTO\COCPoints;

class COCPointsEarning extends Model
{
    use HasFactory, SoftDeletes;

    protected $connection = 'adg_db';

    protected $table = 'coc_points_earnings';

    protected $fillable = [
        'user_id',
        'coc_points_id',
        'points',
        'period',
        'remarks',
        'resulting_points',
        'created_by',
        'updated_by'
    ];

    public function __construct(array $attributes = []){
        $this->table = env('ADG_DB_DATABASE') . '.coc_points_earnings';
        parent::__construct($attributes);
    }

    public function getPointsAttribute($points) {
        return number_format($points, 2);
    }

    public function user() {
        return $this->belongsTo(User::class, 'user_id', 'id');
    }

    public function coc_points() {
        return $this->belongsTo(COCPoints::class, 'coc_points_id', 'id');
    }
    
}
