<?php

namespace Suiterus\Adg\Models\Approvals\CTO;

use App\Models\User;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class COCPoints extends Model
{
    use HasFactory, SoftDeletes;

    protected $connection = 'adg_db';

    protected $table = 'coc_points';

    protected $fillable = [
        'user_id',
        'points',
        'created_by',
        'updated_by'
    ];

    public function __construct(array $attributes = []){
        $this->table = env('ADG_DB_DATABASE') . '.coc_points';
        parent::__construct($attributes);
    }

    public function getPointsAttribute($points) {
        return number_format($points, 2);
    }

    public function user() {
        return $this->belongsTo(User::class, 'user_id', 'id');
    }

    public function cto_application() {
        return $this->hasMany(CTOApplication::class, 'coc_points_id', 'id');
    }

}
