<?php

namespace Suiterus\Adg\Models;

use App\Models\User;
use Suiterus\Adg\Models\SM\Unit;
use Suiterus\Adg\Models\SM\Office;
use Suiterus\Adg\Models\SM\Section;
use Suiterus\Adg\Models\SM\Division;
use Suiterus\Adg\Models\SM\Department;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class ActualDesignation extends Model
{
    use HasFactory;

    protected $fillable = [
        'user_id',
        'office_id',
        'department_id',
        'division_id',
        'section_id',
        'unit_id',
    ];

    public function __construct(array $attributes = [])
    {
        $this->table = env('ADG_DB_DATABASE') . '.actual_designations';
        parent::__construct($attributes);
    }

    public function user()
    {
        return $this->belongsTo(User::class, 'user_id', 'id')->without([
            'currentRole',
            'roles',
            'permissions',
            'storage',
            'employeeMetaInfo',
            'supervisor',
            'user_supervisor',
            'exitInterview',
            'userProfilePicture',
            'profileBasicInfo'
        ]);
    }

    public function office()
    {
        return $this->belongsTo(Office::class, 'office_id', 'id')->without([
            'childOffices',
            'department',
            'headEmployee'
        ]);
    }

    public function department()
    {
        return $this->belongsTo(Department::class, 'department_id', 'id')->without([
            'divisions'
        ]);
    }

    public function division()
    {
        return $this->belongsTo(Division::class, 'division_id', 'id')->without([
            'sections'
        ]);
    }

    public function section()
    {
        return $this->belongsTo(Section::class, 'section_id', 'id')->without([
            'units'
        ]);
    }

    public function unit()
    {
        return $this->belongsTo(Unit::class, 'unit_id', 'id');
    }
}
