<?php

namespace Suiterus\Adg\Models\Activity;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Audit extends Model
{
    use HasFactory;

    protected $fillable = [
        'causer_type',
        'causer_id',
        'auditable_type',
        'auditable_id',
        'event',
        'new_data',
        'old_data',
    ];

    protected $casts = [
        'new_data' => 'json',
    ];

    public function __construct(array $attributes = [])
    {
        $this->table = env('ADG_DB_DATABASE') . '.audit';
        parent::__construct($attributes);
    }

    public function causer(){
        return $this->morphTo();
    }

    public function model(){
        return $this->morphTo();
    }

}
