<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class AddColumnStatusRemarksToCtoApplications extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::connection(env('ADG_DB_CONNECTION'))->table('cto_applications', function (Blueprint $table) {
            $table->integer('status')->comment('0 = Pending, 1 = Approved, 2 = Disapproved, 3 = Cancelled')->change();
            $table->string('status_remarks')->nullable()->after('status');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::connection(env('ADG_DB_CONNECTION'))->table('cto_applications', function (Blueprint $table) {
            $table->dropColumn('status_remarks');
        });
    }
}
