<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class AddNewColumnRosterRescheduleRequestsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::connection(env('ADG_DB_CONNECTION'))->table('roster_reschedule_requests', function(Blueprint $table){
            $table->unsignedBigInteger('requestee_id')->after('user_id');
            $table->unsignedBigInteger('request_date')->change();
            $table->unsignedBigInteger('old_shift_id')->nullable()->after('request_date');
            $table->unsignedBigInteger('new_shift_id')->nullable()->after('old_shift_id');
            $table->text('justification')->nullable()->after('status');

            $table->foreign('requestee_id')->references('id')->on(env('DB_DATABASE'). '.users');
            $table->foreign('request_date')->references('id')->on(env('ADG_DB_DATABASE'). '.roster_days');
            $table->foreign('new_shift_id')->references('id')->on(env('ADG_DB_DATABASE'). '.shifts');
            $table->foreign('old_shift_id')->references('id')->on(env('ADG_DB_DATABASE'). '.shifts');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::connection(env('ADG_DB_CONNECTION'))->table('roster_reschedule_requests', function(Blueprint $table){ 
            $table->dropForeign(['requestee_id']);
            $table->dropForeign(['request_date']);
            $table->dropForeign(['new_shift_id']);
            $table->dropForeign(['old_shift_id']);
            $table->dropColumn(['requestee_id','new_shift_id','old_shift_id','justification']);

        });
    }
}
