<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class AddAveragesColumnToPerformanceEvaluation extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::connection(env('ADG_DB_CONNECTION'))->table('performance_evaluation', function (Blueprint $table) {
            $table->float('rate_q_ave')->nullable()->after('mfo');
            $table->float('rate_e_ave')->nullable()->after('rate_q_ave');
            $table->float('rate_t_ave')->nullable()->after('rate_e_ave');
            $table->float('average')->nullable()->after('rate_t_ave');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::connection(env('ADG_DB_CONNECTION'))->table('performance_evaluation', function (Blueprint $table) {
            //
        });
    }
}
