<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class ModifyCommentOfStatusColumnInLeaveRefundsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::connection(env('ADG_DB_CONNECTION'))->table('leave_refunds', function (Blueprint $table) {
            $table->integer('status')->default(3)->comment('1 = approved, 2 = decline, 3 = review, 4 = refunded, 5 = voided')->change();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::connection(env('ADG_DB_CONNECTION'))->table('leave_refunds', function (Blueprint $table) {
            $table->integer('status')->default(3)->comment('1 = approved, 2 = decline, 3 = review 4 = credited')->change();
        });
    }
}
