<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateLeaveRefundDetailsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::connection(env('ADG_DB_CONNECTION'))->create('leave_refund_details', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('leave_refund_id');
            $table->date('date');
            $table->decimal('credits');
            $table->decimal('amount');
            $table->timestamps();
            $table->softDeletes();

            $table->foreign('leave_refund_id')->references('id')->on(env('ADG_DB_DATABASE'). '.leave_refunds');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::connection(env('ADG_DB_CONNECTION'))->dropIfExists('leave_refund_details');
    }
}
