<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateNightDifferentialPaysTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::connection(env('ADG_DB_CONNECTION'))->create('night_differential_pays', function (Blueprint $table) {
            $table->id();
            $table->float('percentage');
            $table->time('range_start_time');
            $table->time('range_end_time');
            $table->date('effectivity_date');
            $table->integer('status')->default(1)->comment('1 = active, 2 = inactive');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::connection(env('ADG_DB_CONNECTION'))->dropIfExists('night_differential_pays');
    }
}
