<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateLeaveRefundTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::connection(env('ADG_DB_CONNECTION'))->create('leave_refunds', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('user_id');
            $table->unsignedBigInteger('leave_id');
            $table->unsignedBigInteger('earning_deduction_id')->nullable(true);
            $table->decimal('total_credits');
            $table->decimal('total_amount');
            $table->string('reason')->nullable(true);
            $table->integer('status')->default(3)->comment('1 = approved, 2 = decline, 3 = review 4 = credited');
            $table->timestamps();
            $table->softDeletes();

            $table->foreign('earning_deduction_id')->references('id')->on(env('ADG_DB_DATABASE'). '.payroll_earning_deductions');
            $table->foreign('user_id')->references('id')->on(env('DB_DATABASE'). '.users');
            $table->foreign('leave_id')->references('id')->on(env('ADG_DB_DATABASE'). '.leaves');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::connection(env('ADG_DB_CONNECTION'))->dropIfExists('leave_refunds');
    }
}
