<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateAbsenceRateReportDataTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::connection(env('ADG_DB_CONNECTION'))->create('absence_rate_report_data', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('absence_rate_report_id');
            $table->text('date');
            $table->decimal('total_employees');
            $table->decimal('working_days');
            $table->decimal('days_lost');
            $table->timestamps();

            $table->foreign('absence_rate_report_id')->references('id')->on(env('ADG_DB_DATABASE'). '.absence_rate_reports');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::connection(env('ADG_DB_CONNECTION'))->dropIfExists('absence_rate_report_data');
    }
}
