<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class AddOfficeInRosterTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::connection(env('ADG_DB_CONNECTION'))->table('rosters', function (Blueprint $table) {
            $table->unsignedBigInteger('department_id')->nullable(true)->change();
            $table->unsignedBigInteger('office_id')->after('id')->nullable(true);

            $table->foreign('office_id')->references('id')->on(env('ADG_DB_DATABASE'). '.offices');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::disableForeignKeyConstraints();
        Schema::connection(env('ADG_DB_CONNECTION'))->table('rosters', function (Blueprint $table) {
            $table->dropForeign(['office_id']);
            $table->dropForeign(['department_id']);
            $table->dropIndex('rosters_office_id_foreign');
            $table->dropIndex('rosters_department_id_foreign');
        });

        Schema::connection(env('ADG_DB_CONNECTION'))->table('rosters', function (Blueprint $table) {
            $table->dropColumn('office_id');
            $table->unsignedBigInteger('department_id')->nullable(false)->change();
            $table->foreign('department_id')->references('id')->on(env('ADG_DB_DATABASE'). '.departments');
        });

        Schema::enableForeignKeyConstraints();
    }
}
