<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class AddColumnInAbsenceRateReportsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::connection(env('ADG_DB_CONNECTION'))->table('absence_rate_reports', function (Blueprint $table) {
            $table->text('file_path')->after('absent_rate')->nullable();
            $table->text('remarks')->nullable()->after('file_path');
            $table->integer('status')->after('file_path')->comment('1 = pending, 2 = running, 3 =completed, 4 = failed')->nullable();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::connection(env('ADG_DB_CONNECTION'))->table('absence_rate_reports', function (Blueprint $table) {
            $table->dropColumn('file_path');
            $table->dropColumn('remarks');
            $table->dropColumn('status');
        });
    }
}
