<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class AddCreatedByColumnToOrganizationStructures extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {

        Schema::connection(env('ADG_DB_CONNECTION'))->table('offices', function (Blueprint $table) {
            $table->softDeletes();
        });

        Schema::connection(env('ADG_DB_CONNECTION'))->table('departments', function (Blueprint $table) {
            $table->unsignedBigInteger('created_by')->nullable()->after('status');
            $table->unsignedBigInteger('updated_by')->nullable()->after('created_by');
            $table->foreign('created_by')->references('id')->on(env('DB_DATABASE') . '.users');
            $table->foreign('updated_by')->references('id')->on(env('DB_DATABASE') . '.users');
        });

        Schema::connection(env('ADG_DB_CONNECTION'))->table('divisions', function (Blueprint $table) {
            $table->unsignedBigInteger('created_by')->nullable()->after('status');
            $table->unsignedBigInteger('updated_by')->nullable()->after('created_by');
            $table->foreign('created_by')->references('id')->on(env('DB_DATABASE') . '.users');
            $table->foreign('updated_by')->references('id')->on(env('DB_DATABASE') . '.users');
        });

        Schema::connection(env('ADG_DB_CONNECTION'))->table('sections', function (Blueprint $table) {
            $table->unsignedBigInteger('created_by')->nullable()->after('status');
            $table->unsignedBigInteger('updated_by')->nullable()->after('created_by');
            $table->foreign('created_by')->references('id')->on(env('DB_DATABASE') . '.users');
            $table->foreign('updated_by')->references('id')->on(env('DB_DATABASE') . '.users');
        });

        Schema::connection(env('ADG_DB_CONNECTION'))->table('units', function (Blueprint $table) {
            $table->unsignedBigInteger('created_by')->nullable()->after('status');
            $table->unsignedBigInteger('updated_by')->nullable()->after('created_by');
            $table->foreign('created_by')->references('id')->on(env('DB_DATABASE') . '.users');
            $table->foreign('updated_by')->references('id')->on(env('DB_DATABASE') . '.users');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {

        Schema::connection(env('ADG_DB_CONNECTION'))->table('offices', function (Blueprint $table) {
            $table->dropColumn('deleted_at');
        });

        Schema::connection(env('ADG_DB_CONNECTION'))->table('departments', function (Blueprint $table) {
            $table->dropForeign(['created_by']);
            $table->dropColumn('created_by');

            $table->dropForeign(['updated_by']);
            $table->dropColumn('updated_by');
        });

        Schema::connection(env('ADG_DB_CONNECTION'))->table('divisions', function (Blueprint $table) {
            $table->dropForeign(['created_by']);
            $table->dropColumn('created_by');

            $table->dropForeign(['updated_by']);
            $table->dropColumn('updated_by');
        });

        Schema::connection(env('ADG_DB_CONNECTION'))->table('sections', function (Blueprint $table) {
            $table->dropForeign(['created_by']);
            $table->dropColumn('created_by');

            $table->dropForeign(['updated_by']);
            $table->dropColumn('updated_by');
        });

        Schema::connection(env('ADG_DB_CONNECTION'))->table('units', function (Blueprint $table) {
            $table->dropForeign(['created_by']);
            $table->dropColumn('created_by');

            $table->dropForeign(['updated_by']);
            $table->dropColumn('updated_by');
        });
    }
}
