<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class UpdateRosterDivisionSectionUnitTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::connection(env('ADG_DB_CONNECTION'))->table('rosters', function (Blueprint $table) {
            $table->unsignedBigInteger('division_id')->nullable(true)->change();
            $table->unsignedBigInteger('section_id')->after('division_id')->nullable(true);
            $table->unsignedBigInteger('unit_id')->after('section_id')->nullable(true);

            $table->foreign('section_id')->references('id')->on(env('ADG_DB_DATABASE'). '.sections');
            $table->foreign('unit_id')->references('id')->on(env('ADG_DB_DATABASE'). '.units');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::disableForeignKeyConstraints();
        Schema::connection(env('ADG_DB_CONNECTION'))->table('rosters', function (Blueprint $table) {
            $table->dropForeign(['division_id']);
            $table->dropForeign(['section_id']);
            $table->dropForeign(['unit_id']);
            $table->dropIndex('rosters_division_id_foreign');
            $table->dropIndex('rosters_section_id_foreign');
            $table->dropIndex('rosters_unit_id_foreign');
        });

        Schema::connection(env('ADG_DB_CONNECTION'))->table('rosters', function (Blueprint $table) {
            $table->dropColumn('section_id');
            $table->dropColumn('unit_id');
            $table->unsignedBigInteger('division_id')->nullable(false)->change();
            $table->foreign('division_id')->references('id')->on(env('ADG_DB_DATABASE'). '.divisions');
          
        });

        Schema::enableForeignKeyConstraints();
    }
}
