<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class ModifyColumnsInEmployeeSpecialPaysTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::connection(env('ADG_DB_CONNECTION'))->table('employee_special_pays', function (Blueprint $table) {
            $table->foreign('user_id')->references('id')->on(env('DB_DATABASE').'.users');
            $table->foreign('special_pay_id')->references('id')->on(env('ADG_DB_DATABASE').'.special_pays');
            $table->unsignedBigInteger('updated_by')->nullable()->change();
            $table->foreign('created_by')->references('id')->on(env('DB_DATABASE').'.users');
            $table->foreign('updated_by')->references('id')->on(env('DB_DATABASE').'.users');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::connection(env('ADG_DB_CONNECTION'))->table('employee_special_pays', function (Blueprint $table) {
            $table->dropForeign(['user_id']);
            $table->dropForeign(['special_pay_id']);
            $table->dropForeign(['created_by']);
            $table->dropForeign(['updated_by']);
            
        });
    }
}
