<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class ModifyColumnsInSpecialPaysTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::connection(env('ADG_DB_CONNECTION'))->table('special_pays', function (Blueprint $table) {
            $table->unsignedBigInteger('special_pay_frequency_id')->after('description')->nullable();
            $table->decimal('amount')->after('special_pay_frequency_id')->nullable();
            $table->decimal('amount_per_frequency')->after('amount')->nullable();
            $table->date('start_date')->after('amount_per_frequency')->nullable();
            $table->date('end_date')->after('start_date')->nullable();
            $table->integer('period')->after('end_date')->nullable();
            $table->unsignedBigInteger('created_by')->after('period')->nullable();
            $table->unsignedBigInteger('updated_by')->after('created_by')->nullable();
            $table->unsignedBigInteger('deleted_by')->after('updated_by')->nullable();

            $table->foreign('special_pay_frequency_id')->references('id')->on(env('ADG_DB_DATABASE').'.special_pay_frequencies');
            $table->foreign('created_by')->references('id')->on(env('DB_DATABASE').'.users');
            $table->foreign('updated_by')->references('id')->on(env('DB_DATABASE').'.users');
            $table->foreign('deleted_by')->references('id')->on(env('DB_DATABASE').'.users');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::connection(env('ADG_DB_CONNECTION'))->table('special_pays', function (Blueprint $table) {
            $table->dropForeign(['special_pay_frequency_id']);
            $table->dropColumn('special_pay_frequency_id');
            $table->dropColumn('amount');
            $table->dropColumn('amount_per_frequency');
            $table->dropColumn('start_date');
            $table->dropColumn('end_date');
            $table->dropColumn('period');
            $table->dropForeign(['created_by']);
            $table->dropColumn('created_by');
            $table->dropForeign(['updated_by']);
            $table->dropColumn('updated_by');
            $table->dropForeign(['deleted_by']);
            $table->dropColumn('deleted_by');
        });
    }
}
