<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class AddStatusColumnToMetricEvaluation extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::connection(env('ADG_DB_CONNECTION'))->table('metric_evaluation', function (Blueprint $table) {
            $table->integer('status')->default(0)->after('remarks');
            $table->string('revision_remarks')->nullable()->after('status');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::connection(env('ADG_DB_CONNECTION'))->table('metric_evaluation', function (Blueprint $table) {
            $table->dropColumn(['status', 'revision_remarks']);
        });
    }
}
