<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateActualDesignationsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::connection(env('ADG_DB_CONNECTION'))->create('actual_designations', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('user_id');
            $table->unsignedBigInteger('office_id')->nullable();
            $table->unsignedBigInteger('department_id')->nullable();
            $table->unsignedBigInteger('division_id')->nullable();
            $table->unsignedBigInteger('section_id')->nullable();
            $table->unsignedBigInteger('unit_id')->nullable();

            $table->timestamps();

            $table->foreign('user_id')->references('id')->on(env('DB_DATABASE') . '.users');
            $table->foreign('office_id')->references('id')->on(env('ADG_DB_DATABASE') . '.offices');
            $table->foreign('department_id')->references('id')->on(env('ADG_DB_DATABASE') . '.departments');
            $table->foreign('division_id')->references('id')->on(env('ADG_DB_DATABASE') . '.divisions');
            $table->foreign('section_id')->references('id')->on(env('ADG_DB_DATABASE') . '.sections');
            $table->foreign('unit_id')->references('id')->on(env('ADG_DB_DATABASE') . '.units');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::connection(env('ADG_DB_CONNECTION'))->dropIfExists('actual_designations');
    }
}
