<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class AddColumnToEmployeeHeadIdToDivisionSectionUnit extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::connection(env('ADG_DB_CONNECTION'))->table('divisions', function (Blueprint $table) {
            $table->unsignedBigInteger('head_employee_id')->nullable()->after('description');
            $table->foreign('head_employee_id')->references('id')->on(env('DB_DATABASE') . '.users');
        });

        Schema::connection(env('ADG_DB_CONNECTION'))->table('sections', function (Blueprint $table) {
            $table->unsignedBigInteger('head_employee_id')->nullable()->after('description');
            $table->foreign('head_employee_id')->references('id')->on(env('DB_DATABASE') . '.users');
        });

        Schema::connection(env('ADG_DB_CONNECTION'))->table('units', function (Blueprint $table) {
            $table->unsignedBigInteger('head_employee_id')->nullable()->after('description');
            $table->unsignedBigInteger('office_id')->nullable()->after('head_employee_id');
            $table->unsignedBigInteger('department_id')->nullable()->after('office_id');
            $table->foreign('head_employee_id')->references('id')->on(env('DB_DATABASE') . '.users');
            $table->foreign('office_id')->references('id')->on(env('ADG_DB_DATABASE') . '.offices');
            $table->foreign('department_id')->references('id')->on(env('ADG_DB_DATABASE') . '.departments');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::connection(env('ADG_DB_CONNECTION'))->table('divisions', function (Blueprint $table) {
            $table->dropForeign(['head_employee_id']);
            $table->dropColumn('head_employee_id');
        });

        Schema::connection(env('ADG_DB_CONNECTION'))->table('sections', function (Blueprint $table) {
            $table->dropForeign(['head_employee_id']);
            $table->dropColumn('head_employee_id');
        });

        Schema::connection(env('ADG_DB_CONNECTION'))->table('units', function (Blueprint $table) {
            $table->dropForeign(['head_employee_id']);
            $table->dropColumn('head_employee_id');
        });
    }
}
