<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class AddColumnsToEmployeeMetaInfoTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::connection(env('ADG_DB_CONNECTION'))->table('employee_meta_info', function (Blueprint $table) {
            $table->unsignedBigInteger('office_id')->nullable()->after('department_id');
            $table->unsignedBigInteger('section_id')->nullable()->after('office_id');
            $table->unsignedBigInteger('unit_id')->nullable()->after('section_id');

            $table->foreign('office_id')->references('id')->on(env('ADG_DB_DATABASE'). '.offices');
            $table->foreign('section_id')->references('id')->on(env('ADG_DB_DATABASE'). '.sections');
            $table->foreign('unit_id')->references('id')->on(env('ADG_DB_DATABASE'). '.units');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::connection(env('ADG_DB_CONNECTION'))->table('employee_meta_info', function (Blueprint $table) {
            $table->dropForeign(['office_id']);
            $table->dropColumn('office_id');
            $table->dropForeign(['section_id']);
            $table->dropColumn('section_id');
            $table->dropForeign(['unit_id']);
            $table->dropColumn('unit_id');
        });
    }
}
