<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class ModifyColumnInNewUpdatePDSTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::connection(env('ADG_DB_CONNECTION'))->table('new_updates_pds', function (Blueprint $table) {
            $table->dropColumn('file_attachment');
            $table->unsignedBigInteger('eefg_history_id')->after('eefc_id')->nullable();

            $table->foreign('eefg_history_id')->references('id')->on(env('ADG_DB_DATABASE') . '.employee_extra_field_group_histories');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::connection(env('ADG_DB_CONNECTION'))->table('new_updates_pds', function (Blueprint $table) {
            $table->text('file_attachment')->after('reason')->nullable();
            $table->dropForeign(['eefg_history_id']);
            $table->dropColumn(['eefg_history_id']);
        });
    }
}
