<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class ModifyColumnInEmployeeExtraFieldsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::connection(env('ADG_DB_CONNECTION'))->table('employee_extra_fields', function (Blueprint $table) {
            $table->unsignedBigInteger('eefg_id')->after('user_id')->nullable();
            
            $table->foreign('eefg_id')->references('id')->on(env('ADG_DB_DATABASE') . '.employee_extra_field_groups');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::connection(env('ADG_DB_CONNECTION'))->table('employee_extra_fields', function (Blueprint $table) {
            $table->dropForeign(['eefg_id']);
            $table->dropColumn(['eefg_id']);
        });
    }
}
