<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateEmployeeExtraFieldGroupHistoriesTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::connection(env('ADG_DB_CONNECTION'))->create('employee_extra_field_group_histories', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('eefg_id');
            $table->text('file_attachment');
            $table->timestamps();

            $table->foreign('eefg_id')->references('id')->on(env('ADG_DB_DATABASE') . '.employee_extra_field_groups');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::connection(env('ADG_DB_CONNECTION'))->dropIfExists('employee_extra_field_group_histories');
    }
}
