<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateUserMfosTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::connection(env('ADG_DB_CONNECTION'))->create('user_mfos', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('user_id');
            $table->unsignedBigInteger('mfo_id');
            $table->unsignedBigInteger('created_by');
            $table->timestamps();
            $table->foreign('user_id')->references('id')->on(env('DB_DATABASE') . '.users');
            $table->foreign('mfo_id')->references('id')->on(env('ADG_DB_DATABASE') . '.mfos');
            $table->foreign('created_by')->references('id')->on(env('DB_DATABASE') . '.users');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::connection(env('ADG_DB_CONNECTION'))->dropIfExists('user_mfos');
    }
}
