<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class AddForeignConstraintMfoColumnToPerformanceEvaluationTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::connection(env('ADG_DB_CONNECTION'))->table('performance_evaluation', function (Blueprint $table) {
            $table->unsignedBigInteger('mfo')->change();
            $table->foreign('mfo')->references('id')->on(env('ADG_DB_DATABASE') . '.mfos');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::connection(env('ADG_DB_CONNECTION'))->table('performance_evaluation', function (Blueprint $table) {
            $table->dropForeign('performance_evaluation_mfo_foreign');
            $table->dropIndex('performance_evaluation_mfo_foreign');
        });
        Schema::connection(env('ADG_DB_CONNECTION'))->table('performance_evaluation', function (Blueprint $table) {
            $table->integer('mfo')->change();
        });

    }
}
