<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class AddForeignColumnsToEmployeeEvaluation extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::connection(env('ADG_DB_CONNECTION'))->table('employee_evaluation', function (Blueprint $table) {
            $table->unsignedBigInteger('office_id')->nullable()->after('approver');
            $table->unsignedBigInteger('department_id')->nullable()->after('office_id');
            $table->unsignedBigInteger('division_id')->nullable()->after('department_id');
            $table->unsignedBigInteger('section_id')->nullable()->after('division_id');
            $table->unsignedBigInteger('unit_id')->nullable()->after('section_id');

            $table->foreign('office_id')->references('id')->on(env('ADG_DB_DATABASE') . '.offices');
            $table->foreign('department_id')->references('id')->on(env('ADG_DB_DATABASE') . '.departments');
            $table->foreign('division_id')->references('id')->on(env('ADG_DB_DATABASE') . '.divisions');
            $table->foreign('section_id')->references('id')->on(env('ADG_DB_DATABASE') . '.sections');
            $table->foreign('unit_id')->references('id')->on(env('ADG_DB_DATABASE') . '.units');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::connection(env('ADG_DB_CONNECTION'))->table('employee_evaluation', function (Blueprint $table) {

            $table->dropForeign('employee_evaluation_office_id_foreign');
            $table->dropForeign('employee_evaluation_department_id_foreign');
            $table->dropForeign('employee_evaluation_division_id_foreign');
            $table->dropForeign('employee_evaluation_section_id_foreign');
            $table->dropForeign('employee_evaluation_unit_id_foreign');


            $table->dropIndex('employee_evaluation_office_id_foreign');
            $table->dropIndex('employee_evaluation_department_id_foreign');
            $table->dropIndex('employee_evaluation_division_id_foreign');
            $table->dropIndex('employee_evaluation_section_id_foreign');
            $table->dropIndex('employee_evaluation_unit_id_foreign');

            $table->dropColumn(['office_id', 'department_id', 'division_id', 'section_id', 'unit_id']);
        });
    }
}
