<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateCostPerHireReportTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::connection(env('ADG_DB_CONNECTION'))->create('cost_per_hire_reports', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('position_id');
            $table->integer('no_job_post');
            $table->decimal('direct_expenses_total');
            $table->decimal('indirect_expenses_total');
            $table->decimal('cost_per_hire_total');
            $table->timestamps();
            $table->unsignedBigInteger('created_by');
            $table->unsignedBigInteger('updated_by')->nullable();

            $table->foreign('position_id')->references('id')->on(env('HRJP_DB_DATABASE') . '.positions');
            $table->foreign('created_by')->references('id')->on(env('DB_DATABASE') . '.users');
            $table->foreign('updated_by')->references('id')->on(env('DB_DATABASE') . '.users');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::connection(env('ADG_DB_CONNECTION'))->dropIfExists('cost_per_hire_reports');
    }
}
