<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class AddColumnsInEmployeeEvaluationTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::connection(env('ADG_DB_CONNECTION'))->table('employee_evaluation', function (Blueprint $table) {
            $table->string('employee_ip_address')->after('employee_id')->nullable();
            $table->string('evaluator_ip_address')->after('evaluator')->nullable();
            $table->string('approver_ip_address')->after('approver')->nullable();
            $table->integer('status')->comment('0 = in progress, 1 = submitted, 2 = for approval, 3 = approved, 4 = acknowledged, 5 = declined, 6 = stamped')->change();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::connection(env('ADG_DB_CONNECTION'))->table('employee_evaluation', function (Blueprint $table) {
            $table->dropColumn('employee_ip_address');
            $table->dropColumn('evaluator_ip_address');
            $table->dropColumn('approver_ip_address');
            $table->integer('status')->comment('0 = in progress, 1 = submitted, 2 = for approval, 3 = approved, 4 = acknowledged, 5 = declined')->change();
        });
    }
}
