<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateRosterTransferRemarks extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::connection(env('ADG_DB_CONNECTION'))->create('roster_transfer_remarks', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('old_employee_group_id');
            $table->unsignedBigInteger('new_employee_group_id');
            $table->string('remarks');
            $table->timestamps();
            $table->unsignedBigInteger('created_by');
            $table->unsignedBigInteger('updated_by')->nullable();

            $table->foreign('old_employee_group_id')->references('id')->on(env('ADG_DB_DATABASE') . '.roster_employees_per_groups');
            $table->foreign('new_employee_group_id')->references('id')->on(env('ADG_DB_DATABASE') . '.roster_employees_per_groups');
            $table->foreign('created_by')->references('id')->on(env('DB_DATABASE') . '.users');
            $table->foreign('updated_by')->references('id')->on(env('DB_DATABASE') . '.users');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::connection(env('ADG_DB_CONNECTION'))->dropIfExists('roster_transfer_remarks');
    }
}
