<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateMentorshipReports extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::connection(env('ADG_DB_CONNECTION'))->create('mentorship_reports', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('mentorship_id');
            $table->text('goal_details')->nullable();
            $table->text('goal_timeline')->nullable();
            $table->text('goal_remarks')->nullable();
            $table->text('realities_details')->nullable();
            $table->text('realities_timeline')->nullable();
            $table->text('realities_remarks')->nullable();
            $table->text('options_details')->nullable();
            $table->text('options_timeline')->nullable();
            $table->text('options_remarks')->nullable();
            $table->text('way_forward_details')->nullable();
            $table->text('way_forward_timeline')->nullable();
            $table->text('way_forward_remarks')->nullable();
            $table->unsignedBigInteger('created_by');
            $table->unsignedBigInteger('updated_by')->nullable();
            $table->timestamps();
            $table->foreign('mentorship_id')->references('id')->on(env('ADG_DB_DATABASE') . '.mentorships');
            $table->foreign('created_by')->references('id')->on(env('DB_DATABASE') . '.users');
            $table->foreign('updated_by')->references('id')->on(env('DB_DATABASE') . '.users');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::connection(env('ADG_DB_CONNECTION'))->dropIfExists('mentorship_reports');
    }
}
