<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class AddColumnInAttedanceTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::connection(env('ADG_DB_CONNECTION'))->table('attendances', function (Blueprint $table) {
            $table->string('device_break_in')->nullable(true)->after('device_out');
            $table->string('device_break_out')->nullable(true)->after('device_break_in');
            $table->tinyInteger('break_in_state')->comment('1 = fingerprint, 2 = rfid/card, 16 = face, 0 = password, 5 = system')->default(5)->nullable(true)->after('time_out_state');
            $table->tinyInteger('break_out_state')->comment('1 = fingerprint, 2 = rfid/card, 16 = face, 0 = password, 5 = system')->default(5)->nullable(true)->after('break_in_state');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::connection(env('ADG_DB_CONNECTION'))->table('attendances', function (Blueprint $table) {
            $table->dropColumn('device_break_in');
            $table->dropColumn('device_break_out');
            $table->dropColumn('break_in_state');
            $table->dropColumn('break_out_state');
        });
    }
}
