<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class ModifyColumnInMentorshipInvitesTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::connection(env('ADG_DB_CONNECTION'))->table('mentorship_invites', function (Blueprint $table) {
            $table->dropForeign(['mentorship_id']);
            $table->dropColumn(['mentorship_id']);
            $table->unsignedBigInteger('session_id')->after('id')->nullable();
            $table->foreign('session_id')->references('id')->on(env('ADG_DB_DATABASE'). '.mentorship_sessions');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::connection(env('ADG_DB_CONNECTION'))->table('mentorship_invites', function (Blueprint $table) {
            $table->unsignedBigInteger('mentorship_id')->after('id');
            $table->foreign('mentorship_id')->references('id')->on(env('ADG_DB_DATABASE') . '.mentorships');
            $table->dropForeign(['session_id']);
            $table->dropColumn(['session_id']);
        });
    }
}
