<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateMentorshipSessionsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::connection(env('ADG_DB_CONNECTION'))->create('mentorship_sessions', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('mentorship_id');
            $table->unsignedBigInteger('session_number');
            $table->text('key_points')->nullable();
            $table->text('process_observation')->nullable();
            $table->unsignedBigInteger('created_by');
            $table->unsignedBigInteger('updated_by')->nullable();
            $table->timestamps();
            $table->foreign('mentorship_id')->references('id')->on(env('ADG_DB_DATABASE') . '.mentorships');
            $table->foreign('created_by')->references('id')->on(env('DB_DATABASE') . '.users');
            $table->foreign('updated_by')->references('id')->on(env('DB_DATABASE') . '.users');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::connection(env('ADG_DB_CONNECTION'))->dropIfExists('mentorship_sessions');
    }
}
