<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateBalanceScoreCardsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::connection(env('ADG_DB_CONNECTION'))->create('balance_score_cards', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('first_half_metric_evaluation_id')->nullable();
            $table->unsignedBigInteger('second_half_metric_evaluation_id')->nullable();
            $table->text('objectives')->nullable();
            $table->text('plans')->nullable();
            $table->text('success_indicator')->nullable();
            $table->text('q1_action_plan')->nullable();
            $table->text('q1_status')->nullable();
            $table->integer('q1_legend')->nullable()->comment('1 = cancelled, 2 = follow up, 3 = ongoing, 4 = completed');
            $table->text('q2_action_plan')->nullable();
            $table->text('q2_status')->nullable();
            $table->integer('q2_legend')->nullable()->comment('1 = cancelled, 2 = follow up, 3 = ongoing, 4 = completed');
            $table->integer('first_half_legend')->nullable()->comment('1 = cancelled, 2 = follow up, 3 = ongoing, 4 = completed');
            $table->text('q3_action_plan')->nullable();
            $table->text('q3_status')->nullable();
            $table->integer('q3_legend')->nullable()->comment('1 = cancelled, 2 = follow up, 3 = ongoing, 4 = completed');
            $table->text('q4_action_plan')->nullable();
            $table->text('q4_status')->nullable();
            $table->integer('q4_legend')->nullable()->comment('1 = cancelled, 2 = follow up, 3 = ongoing, 4 = completed');
            $table->integer('annual_legend')->nullable()->comment('1 = cancelled, 2 = follow up, 3 = ongoing, 4 = completed');
            $table->timestamps();
            $table->unsignedBigInteger('created_by');
            $table->unsignedBigInteger('updated_by')->nullable();
            $table->foreign('first_half_metric_evaluation_id')->references('id')->on(env('ADG_DB_DATABASE'). '.metric_evaluation');
            $table->foreign('second_half_metric_evaluation_id')->references('id')->on(env('ADG_DB_DATABASE'). '.metric_evaluation');
            $table->foreign('created_by')->references('id')->on(env('DB_DATABASE').'.users');
            $table->foreign('updated_by')->references('id')->on(env('DB_DATABASE').'.users');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::connection(env('ADG_DB_CONNECTION'))->dropIfExists('balance_score_cards');
    }
}
