<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class AddColumnLongevityPaysTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::connection(env('ADG_DB_CONNECTION'))->table('longevity_pays', function(Blueprint $table) {
            $table->integer('status')->default(1)->comment('1 = active, 2 = inactive')->after('total_pay');
            $table->double('salary_rate')->after('number');
            $table->integer('percentage')->after('salary_rate');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::connection(env('ADG_DB_CONNECTION'))->table('longevity_pays', function(Blueprint $table) {
            $table->dropColumn(['status', 'percentage', 'salary_rate']);
        });
    }
}
