<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateRescheduleExamPromotionTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::connection(env('ADG_DB_CONNECTION'))->create('promotion_reschedule', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('application_process_id');
            $table->dateTime('schedule')->nullable(true);
            $table->text('reason')->nullable(true);
            $table->integer('status')->comment('1 - pending, 2 - approved, 3 - rejected')->nullable(true);  
            $table->unsignedBigInteger('created_by')->nullable(true);
            $table->softDeletes();
            $table->timestamps();

            $table->foreign('application_process_id')->references('id')->on(env('ADG_DB_DATABASE'). '.promotion_process')->onDelete('cascade');
            $table->foreign('created_by')->references('id')->on(env('DB_DATABASE') . '.users');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::connection(env('ADG_DB_CONNECTION'))->dropIfExists('promotion_reschedule');
    }
}
