<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateSupplementaryDetailsUsersTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::connection(env('ADG_DB_CONNECTION'))->create('supplemental_detail_users', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('application_id');
            $table->unsignedBigInteger('supplemental_detail_id');
            $table->text('attachment')->nullable();
            $table->integer('status')->comment('1 - pending, 2 - approved, 3 - declined')->nullable();  
            $table->text('justification')->nullable();
            $table->softDeletes();
            $table->timestamps();

            $table->foreign('application_id')->references('id')->on(env('ADG_DB_DATABASE'). '.promotion_application')->onDelete('cascade');
            $table->foreign('supplemental_detail_id')->references('id')->on(env('HRJP_DB_DATABASE'). '.supplemental_details')->onDelete('cascade');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::connection(env('ADG_DB_CONNECTION'))->dropIfExists('supplemental_detail_users');
    }
}
