<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateEmployeeExamPromotion extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::connection(env('ADG_DB_CONNECTION'))->create('promotion_process', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('application_id');
            $table->timestamp('schedule')->nullable(true);
            $table->string('interviewer')->nullable(true);
            $table->text('link')->nullable(true);
            $table->text('description')->nullable(true);
            $table->integer('step');
            $table->integer('status');
            $table->unsignedBigInteger('created_by');
            $table->unsignedBigInteger('updated_by')->nullable(true);
            $table->softDeletes();
            $table->timestamps();
            $table->foreign('application_id')->references('id')->on(env('ADG_DB_DATABASE') . '.promotion_application');
            $table->foreign('created_by')->references('id')->on(env('DB_DATABASE') . '.users');
            $table->foreign('updated_by')->references('id')->on(env('DB_DATABASE') . '.users');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::connection(env('ADG_DB_CONNECTION'))->dropIfExists('promotion_process');
    }
}
