<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateAdgAppointmentFormsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::connection(env('ADG_DB_CONNECTION'))->create('appointment_forms', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('employee_type_history_id');
            $table->text('file_path');
            $table->unsignedBigInteger('created_by');
            $table->timestamps();
            $table->foreign('employee_type_history_id')->references('id')->on(env('ADG_DB_DATABASE') . '.employee_type_histories');
            $table->foreign('created_by')->references('id')->on(env('DB_DATABASE') . '.users');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::connection(env('ADG_DB_CONNECTION'))->dropIfExists('appointment_forms');
    }
}
