<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class AddPercentageAndOverallRateToPerformanceEvaluationTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::connection(env('ADG_DB_CONNECTION'))->table('performance_evaluation', function (Blueprint $table) {
            $table->float('overall_rate')->after('mfo')->nullable();
            $table->float('percentage')->after('overall_rate')->nullable();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::connection(env('ADG_DB_CONNECTION'))->table('performance_evaluation', function (Blueprint $table) {
            $table->dropColumn('overall_rate');
            $table->dropColumn('percentage');
        });
    }
}
