<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateDynamicContributionTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::connection(env('ADG_DB_CONNECTION'))->create('contributions', function (Blueprint $table) {
            $table->id();
            $table->string('name');
            $table->integer('type')->comment('1 = philhealth, 2 = gsis, 3 = pagibig');
            $table->decimal('employee_share');
            $table->decimal('company_share');
            $table->integer('savings_rate')->nullable();
            $table->date('effectivity_date');
            $table->text('description')->nullable(true);
            $table->integer('status');
            $table->unsignedBigInteger('created_by');
            $table->timestamps();
            $table->softDeletes();

            $table->foreign('created_by')->references('id')->on(env('DB_DATABASE').'.users');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::connection(env('ADG_DB_CONNECTION'))->dropIfExists('contributions');
    }
}
