<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreatePayrollHolidayBreakdownsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::connection(env('ADG_DB_CONNECTION'))->create('payroll_holiday_breakdowns', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('earning_deduction_id');
            $table->unsignedBigInteger('holiday_id');
            $table->date('date');
            $table->double('holiday_pay');
            $table->timestamps();
            $table->foreign('earning_deduction_id')->references('id')->on(env('ADG_DB_DATABASE') . '.payroll_earning_deductions');
            $table->foreign('holiday_id')->references('id')->on(env('ADG_DB_DATABASE') . '.holidays');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::connection(env('ADG_DB_CONNECTION'))->dropIfExists('payroll_holiday_breakdowns');
    }
}
