<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class ModifyAttendanceTableBreakTimeColumn extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::connection(env('ADG_DB_CONNECTION'))->table('attendances', function (Blueprint $table) {
            $table->dateTime('break_in')->nullable()->change();
            $table->dateTime('break_out')->nullable()->change();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::connection(env('ADG_DB_CONNECTION'))->table('attendances', function (Blueprint $table) {
            $table->time('break_in')->nullable()->change();
            $table->time('break_out')->nullable()->change();
        });
    }
}
