<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class AddColumnRemarksToMetricEvaluation extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::connection(env('ADG_DB_CONNECTION'))->table('metric_evaluation', function (Blueprint $table) {
            $table->text('remarks_q')->after('rate_t')->nullable();
            $table->text('remarks_e')->after('remarks_q')->nullable();
            $table->text('remarks_t')->after('remarks_e')->nullable();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::connection(env('ADG_DB_CONNECTION'))->table('metric_evaluation', function (Blueprint $table) {
            $table->dropColumn(['remarks_q', 'remarks_e', 'remarks_t']);
        });
    }
}
