<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class AddNewColumnPayrollEmployees extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::connection(env('ADG_DB_CONNECTION'))->table('payroll_employees', function (Blueprint $table) {
            $table->double('total_basic_pay_deduction')->nullable()->after('deductions');
            $table->double('total_pera_pay_deduction')->nullable()->after('total_basic_pay_deduction');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::connection(env('ADG_DB_CONNECTION'))->table('payroll_employees', function (Blueprint $table) {
            $table->dropColumn(['total_basic_pay_deduction', 'total_pera_pay_deduction']);
        });
    }
}
