<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateOfficeHierarchyTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::connection(env('ADG_DB_CONNECTION'))->create('office_hierarchy', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('parent_office_id')->nullable();
            $table->unsignedBigInteger('child_office_id')->nullable();
            $table->unsignedBigInteger('created_by');
            $table->timestamps();
            $table->foreign('parent_office_id')->references('id')->on(env('ADG_DB_DATABASE') . '.offices');
            $table->foreign('child_office_id')->references('id')->on(env('ADG_DB_DATABASE') . '.offices');
            $table->foreign('created_by')->references('id')->on(env('DB_DATABASE') . '.users');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::connection(env('ADG_DB_CONNECTION'))->dropIfExists('office_hierarchy');
    }
}
